# --------------------------
# --------------------------
# Figure 2 & S1: Pareto optimum
# --------------------------
# --------------------------

rootDirectory = '' # YOU must set this!

rdaInputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figures 2 & S1 - Pareto optimum figure/RDA', sep = '')
figureOutputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figures 2 & S1 - Pareto optimum figure', sep = '')
functionDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Functions', sep = '')
source(paste(functionDirectory,'callFunctions.R', sep = ''))
callFunctions(functionDirectory)

library(raster)
library(fields)

setwd(rdaInputDirectory)
load('Figure2_trials.rda')
load('Figure2_grids.rda')

VMR = data$VMR
failure.perc = data$failure.perc
avgTimeToSuccess = data$avgTimeToSuccess

# ----------------------------
# Figure 2 - Pareto optimum
# ---------------------------- 

# --- Determine colors ------

col = alpha(colorRampPalette(c('blue','red'))(1000),0.5)
VMRColSeq = exp(seq(log(min(VMR)), log(max(VMR)), length.out = 1000))
colIndex = rep(NA, times = length(VMR))
for(i_matrix in 1:length(VMR)){
  colIndex[i_matrix] = which.min(abs(VMR[i_matrix] - VMRColSeq))
}

# --- Main panel ------

setwd(figureOutputDirectory)
tiff('Figure2_mainPanel.tiff', width = 2300, height = 2400, res = 300)
par(mar = c(5,5,4,4))
plot(avgTimeToSuccess ~ failure.perc, log = '', bty = 'n',
     pch = '.', col = col[colIndex], cex = 5, cex.lab = 1.5, cex.axis = 1.4,
     ylim = c(1,2500), xlim = c(10,70),
     ylab = 'Avg. time steps to 100% cover', xlab = 'Chance of restoration failure (%)')
dev.off()

# ----- Colorbar legend

values = exp(seq(log(min(VMR)),log(max(VMR)),length.out = 5))
values = c(0.17, 0.76, 3.5, 16, 72)
VMRSeq = rev(seq(0.166,72, length.out = 1000))
colVMR = rev(colorRampPalette(c('blue','red'))(1000))
setwd(figureOutputDirectory)
tiff('Figure2_legend.tif', width = 700*3, height = 700*3, res = 300)
par(mfrow = c(1,1))
plot(c(1), xlim = c(0,1), ylim = c(0,1), type = 'n', bty = 'n', yaxt = 'n', xaxt = 'n', ylab = '', xlab = '')
fields::colorbar.plot(x = 0.5, y = 0.5, 
              strip.length = 0.62, strip.width = 0.05,
              strip = VMRSeq, col = colVMR, horizontal = T)
valueList = c(0.166,0.5,1,2,6,20,72)
for(i in 1:length(valueList)){
  x = seq(0.2,0.8, length.out = 1000)[which.min(abs(exp(seq(log(min(VMR)),log(max(VMR)),length.out = 1000)) - valueList[i]))]
  lines(x = c(x, x), y = c(0.525, 0.54), lwd = 2) #0.166
  if(valueList[i] == 1){
    lines(x = c(x, x), y = c(0.46, 0.54), lwd = 2) #0.166
  }
  text(x = x, y = 0.6, valueList[i], cex = 1.2, srt = 270)
}
rect(xright = 0.2, xleft = 0.8, ytop = 0.525, ybottom =  0.475, lwd = 2)
text(y = 0.43, x= 0.5, 'Variance/mean ratio (VMR)', cex = 1.3)
text(y = 0.37, x= 0.58, 'Clustered', cex = 1.3, col = alpha('red',0.9))
text(y = 0.37, x= 0.29, 'Regular', cex = 1.2, col = alpha('blue',0.9))
dev.off()


# ----------------------------
# Figure S1 - Correlation w/ VMR metric
# ---------------------------- 
# Figure S1a

setwd(figureOutputDirectory)
tiff('FigureS2a.tiff', width = 1750, height = 1600, res = 300)
par(mfrow = c(1,1))
par(mar = c(5,5,4,4))
plot(failure.perc ~ VMR, log = 'x',
     pch = '.', col = col[colIndex], cex = 5, cex.lab = 1.3, cex.axis = 1.2,
     ylim = c(10,70),
     xlim = c(0.1,100),
     ylab = 'Chance of restoration failure (%)', xlab = 'Variance/mean ratio (VMR)')
m = lm(log(failure.perc) ~ poly(log(VMR), degree = 3, raw = T))
summary(m)
xv = exp(seq(log(min(VMR)), log(max(VMR)), length.out = 1000))
yv = exp(m$coefficients[1] 
         + m$coefficients[2]*log(xv) 
         + m$coefficients[3]*log(xv)^2 
         + m$coefficients[4]*log(xv)^3)
yv[xv > xv[which.min(yv)]] = min(yv)
lines(yv ~ xv, col = grey(0.7), lwd = 3)
lines(yv ~ xv, col = 'black', lty = 2)
dev.off()

# --------- In-text statement on AIC fits
m0 = lm(failure.perc ~ log(VMR))
m1 = lm(failure.perc ~ poly(log(VMR), degree = 2, raw = T))
m2 = lm(failure.perc ~ poly(log(VMR), degree = 3, raw = T))
m3 = lm(log(failure.perc) ~ log(VMR))
m4 = lm(log(failure.perc) ~ poly(log(VMR), degree = 2, raw = T))
m5 = lm(log(failure.perc) ~ poly(log(VMR), degree = 3, raw = T))

print(AIC(m0,m1,m2,m3,m4,m5))

# --------------------------
# Figure S1b

setwd(figureOutputDirectory)
tiff('FigureS2b.tiff', width = 1750, height = 1600, res = 300)
par(mar = c(5,5,4,4))
plot(avgTimeToSuccess ~ VMR, log = 'x',
     pch = '.', col = col[colIndex], cex = 5, cex.lab = 1.3, cex.axis = 1.2,
     ylim = c(1,2500), xlim = c(0.1,100),
     ylab = 'Average no. time steps to 100% cover', xlab = 'Variance/mean ratio (VMR)')
m = lm(log(avgTimeToSuccess) ~ log(VMR))
m = lm(log(avgTimeToSuccess) ~ poly(log(VMR), degree = 3, raw = T))
summary(m)
xv = exp(seq(log(min(VMR)), log(max(VMR)), length.out = 1000))
yv = exp(m$coefficients[1] 
         + m$coefficients[2]*log(xv) 
         + m$coefficients[3]*log(xv)^2 
         + m$coefficients[4]*log(xv)^3) 
lines(yv ~ xv, col = grey(0.7), lwd = 3)
lines(yv ~ xv, col = 'black', lty = 2)
dev.off()

# --------- In-text statement on AIC fits
m0 = lm(failure.perc ~ log(VMR))
m1 = lm(failure.perc ~ poly(log(VMR), degree = 2, raw = T))
m2 = lm(failure.perc ~ poly(log(VMR), degree = 3, raw = T))
m3 = lm(log(failure.perc) ~ log(VMR))
m4 = lm(log(failure.perc) ~ poly(log(VMR), degree = 2, raw = T))
m5 = lm(log(failure.perc) ~ poly(log(VMR), degree = 3, raw = T))

print(AIC(m0,m1,m2,m3,m4,m5))

# ---------------------------------------------
# Sub frames

closestTo = function(x, seq)
{
  return(which.min(abs(x - seq)))
}
valueList = rev(c(72, 49, 25, 11, 2.5, 0.5, 0.18, 0.34))
index = unlist(lapply(X = valueList, FUN = closestTo, seq = VMR))

setwd(figureOutputDirectory)
tiff(filename = '%04d.tif', width = 20, height = 20, units = 'cm', res = 300)
for(i_frame in index){
  plot(raster(MiSeries[,,i_frame]))
}
dev.off()

